var upload_number = 1;
var maximum_uploads = 5;
var active_image_sets = 1;
var assigned_ids = [];
var top = 0;
var tmp_image_path = window.location.origin + "/qa/cms/img/placeholder.png";
var delete_path = window.location.origin + "/qa/cms/img/delete.png";

if(typeof cms_path === 'undefined' || cms_path === null) {
   tmp_image_path = window.location.origin + cms_path + "/img/placeholder.png";
   delete_path = window.location.origin + cms_path + "/img/delete.png";
 }

function updateCounter(){
	for(var i=1; i <= maximum_uploads; i++){
		if(assigned_ids['div'+i] != true){
			upload_number = i;
			break;
		}
	}
}

function addFileInput() {
	// Stop if maximum uploads is reached
	if(active_image_sets > maximum_uploads)
	{
		return;
	}

	updateCounter();
		
 	var d = document.createElement("div");
 	var file = document.createElement("input");
 	var picture = document.createElement("img");
 	var p = document.createElement("p");
	var a = document.createElement("a");
	var deleteicon = document.createElement("img");
	
	a.setAttribute("href", "javascript:");
	a.setAttribute("align", "center");
	
	deleteicon.setAttribute("src", delete_path);
	deleteicon.setAttribute("height", "15px");
	deleteicon.setAttribute("width", "15px");
	deleteicon.setAttribute("title", "Remove");
	deleteicon.setAttribute("class", "move-forward");
	deleteicon.setAttribute("onclick", "removePicture('div" + upload_number + "')");
	
	a.appendChild(deleteicon);
	
	d.setAttribute("class", "image-set");
	d.setAttribute("id", "div"+upload_number);
	
	p.setAttribute("align", "center");
	p.setAttribute("id", "pimageview"+upload_number);
	p.setAttribute("name", "pimageview"+upload_number);
	
	picture.setAttribute("src", tmp_image_path);
	picture.setAttribute("width","100px");
	picture.setAttribute("height","75px");
	picture.setAttribute("name","imageview"+upload_number);
	picture.setAttribute("id","imageview"+upload_number);
	picture.setAttribute("onclick","browsePicture('image" + upload_number + "');");
 	
 	file.setAttribute("type", "file");
 	file.setAttribute("name", "image"+upload_number);
 	file.setAttribute("id", "image"+upload_number);
 	file.setAttribute("onchange", "readURL(this, 'imageview" + upload_number + "');");
	
	d.appendChild(a);
	d.innerHTML = d.innerHTML + "<br/>";
	d.appendChild(picture);
	d.innerHTML = d.innerHTML + "<br/>";
	d.appendChild(p);
	d.appendChild(file);
 	document.getElementById("moreUploads").appendChild(d);
	
	// update the assigned ids and other variables
	assigned_ids['div'+upload_number] = true;
 	upload_number++;
	active_image_sets++;
	
	// update size of the div
	document.getElementById("moreUploads").style.width = "95%";
	document.getElementById("moreUploads").style.height = "155px";
}

function readURL(input,imageid) {
	if (input.files && input.files[0]) {
		var reader = new FileReader();

		reader.onload = function (e) {
			
			if(input.files[0].type == 'application/pdf'){
				
				$('#' + imageid).attr('src', tmp_image_path)
			}else{
				$('#' + imageid)
				.attr('src', e.target.result);
			}
			document.getElementById("p" + imageid).innerHTML = input.value;
			addFileInput();
		};
		reader.readAsDataURL(input.files[0]);
	}
}

function browsePicture(inputid){
	$("#" + inputid).click();
}

function removePicture(picturesetid){
	var pictureset = document.getElementById(picturesetid);
	pictureset.parentNode.removeChild(pictureset);
	
	// update the assigned ids and other variables
	assigned_ids[picturesetid] = false;
	active_image_sets--;
	
	// if all pictures have been removed, show the add new picture link
	if (active_image_sets <= 1){
		document.getElementById('moreUploadsLink').style.display='block';
		document.getElementById("moreUploads").style.width = "0px";
		document.getElementById("moreUploads").style.height = "0px";
	}
}