<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */

$cakeDescription = 'CakePHP: the rapid development php framework';
?>
<!DOCTYPE html>
<html>

<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous"
        nonce="<?= $styleNonce ?>">
</head>

<title>
    <?= $cakeDescription ?>:
    <?= $this->fetch('title') ?>
</title>

<?= $this->Html->meta('icon') ?>

<?= $this->Html->css(['simple-sidebar', 'style', 'custom_radio', 'jquery-ui.min']) ?>

<?= $this->fetch('meta') ?>
<?= $this->fetch('css') ?>
<?= $this->fetch('script') ?>
</head>

<body>

    <nav class="top-bar">
        <?php echo $this->element('top_bar'); ?>
    </nav>

    <!-- WRAPPER -->
    <div id="wrapper">

        <main class="main">
            <div class="container">
                <?= $this->fetch('content') ?>
            </div>
        </main>

        <footer>
            <div class="container-fluid">
                <span class="copyright">&copy; 2017 <a href="https://www.themeineed.com" target="_blank">Theme I
                        Need</a>.
                    All Rights Reserved.
                </span>
            </div>
        </footer>

    </div>

    <div id="footer">
        <?php echo $this->element('footer'); ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous"
        nonce="<?= $scriptNonce ?>"></script>
</body>

</html>