<!-- Bottom Pagination Controls -->
<div class="row mb-3">
    <div class="col-sm-6">
        <?= $this->Paginator->counter(
            __('Page {{page}} of {{pages}}, showing {{current}} records out of {{count}} total')
        ) ?>
    </div>
    <div class="col-sm-6 text-end"> <!-- Use text-end for Bootstrap 5 -->
        <nav aria-label="Page navigation">
            <ul class="pagination justify-content-end mb-0">
                <?= $this->Paginator->prev(
                    '< ' . __('Prev'), 
                    [
                        'escape' => false,
                        'url' => array_merge(
                            $this->request->getQueryParams(),
                            ['controller' => $slug, 'action' => $this->request->getParam('action'), 'page' => $this->Paginator->current() - 1]
                        ),
                        'class' => 'page-item' // Add Bootstrap pagination classes
                    ],
                    ['class' => 'page-link'] // Add Bootstrap pagination link classes
                ) ?>

                <?= $this->Paginator->numbers([
                    'before' => '<li class="page-item">', 
                    'after' => '</li>',
                    'tag' => 'li',
                    'class' => 'page-item',
                    'link' => [
                        'class' => 'page-link'
                    ],
                    'first' => 3,
                    'last' => 3,
                    'modulus' => 4,
                    'url' => ['controller' => $slug, 'action' => $this->request->getParam('action')]
                ]) ?>

                <?= $this->Paginator->next(
                    __('Next') . ' >', 
                    [
                        'escape' => false,
                        'url' => array_merge(
                            $this->request->getQueryParams(),
                            ['controller' => $slug, 'action' => $this->request->getParam('action'), 'page' => $this->Paginator->current() + 1]
                        ),
                        'class' => 'page-item' // Add Bootstrap pagination classes
                    ],
                    ['class' => 'page-link'] // Add Bootstrap pagination link classes
                ) ?>
            </ul>
        </nav>
    </div>
</div>
