<?= $this->Form->create($album, ['enctype' => 'multipart/form-data', 'class' => 'row g-3']) ?>

<div class="col-12">
    <div class="mb-3 row">
        <label class="col-sm-3 col-form-label" for="name">Name</label>
        <div class="col-sm-6">
            <?= $this->Form->control('name', ['id' => 'name', 'class' => 'form-control', 'label' => false, 'required' => true]); ?>
        </div>
    </div>

    <div class="mb-3 row">
        <label class="col-sm-3 col-form-label" for="description">Description</label>
        <div class="col-sm-6">
            <?= $this->Form->control('description', ['id' => 'description', 'class' => 'form-control', 'label' => false]); ?>
        </div>
    </div>

    <div class="mb-3 row">
        <label class="col-sm-3 col-form-label" for="image_path">Image</label>
        <div class="col-sm-6">
            <?= $this->Form->control('image_path', ['id' => 'image_path', 'class' => 'form-control', 'label' => false, 'type' => 'file']); ?>
        </div>
    </div>

    <?php if (!empty($album->image_path)): ?>
    <div class="mb-3 row">
        <label class="col-sm-3 col-form-label">Old image</label>
        <div class="col-sm-6">
            <?= $this->Html->image(Cake\Core\Configure::read('IMAGE_PREPATH') . $album->image_path, ['class' => 'img-fluid', 'style' => 'max-width: 200px; max-height: 200px;']); ?>
        </div>
    </div>
    <?php endif; ?>

		<div class="row">
            <div class="col-md-9 col-sm-6 d-flex justify-content-end align-items-end my-4">
                <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary pull-right']) ?>
            </div>
        </div>
</div>

<?= $this->Form->end() ?>
