<?= $this->Form->create($section, ['enctype' => 'multipart/form-data', 'class'=>'form-horizontal row-fluid']) ?>
<div class="row form-area">
	<div class="col-sm-12">
		<div class="row form-group">
			<div class="col-sm-3 col-xs-12 field-label">
				Name
			</div>
			<div class="col-sm-7 col-xs-12 text-input">
				<?= $this->Form->input('name', ['class' => 'form-control', 'label' => false, 'required']);?>
			</div>
		</div>
		
		<div class="row form-group">
			<div class="col-sm-3 col-xs-12 field-label">
				Description
			</div>
			<div class="col-sm-7 col-xs-12 text-input">
				<?= $this->Form->input('description', ['class' => 'form-control', 'label' => false, 'required']);?>
			</div>
		</div>

		
		<?php if($level!=0): ?>
		<div class="row form-group" id="parent_sections">
			<div class="col-sm-3 col-xs-12 field-label">
			 Parent Category
			</div>
			<div class="col-sm-7 col-xs-12 select-input">
				<?= $this->Form->input('parent_category_id', ['class' => 'form-control', 'options' => $parentSections, 'label' => false, 'empty'=>'-- Select --']);?>
				
			</div>
			
			
		</div>
		<?php endif; ?>
		<div class="row form-group">
			
			<div class="col-sm-9 col-xs-12 col-sm-offset-3">
				<?= $this->Form->button('Save', ['class' => 'btn btn-primary']); ?>
			</div>
		</div>		
	</div>
</div>
<?= $this->Form->end() ?>
	
<script>
$('#parent_category_name').val($('#parent-category-id option:selected').text());
	$(document).ready(function(){
		$('body').on('change', '#parent-category-id', function(event){
			var category_id = $(this).val(),
				category_text = $('#parent-category-id option:selected').text();

			$('#parent_category_name').val(category_text);
			$('input[name=parent_id]').val(category_id);

			$.ajax({   
				type: "POST",

				cache: false,        
				processData: false,
				contentType: false,
				url: "<?php echo $this->Url->build(["controller" => "Items", "action" => "getSections", ]); ?>"+"/"+category_id,
				success: function(data){	
					data = $.parseJSON(data);
					
					$('#parent-category-id').html('');
					$('#parent-category-id').append("<option value=''>--- Select --</option>");
		  			$.each(data, function(index,item){
						$('#parent-category-id').append("<option value='"+item.id+"'>"+item.name+"</option>");
					});
						
			
								
				},
				error: function(data){
									
				}   
			});   
		});


		$('body').on('click', '.go-back', function(event){

			event.preventDefault();
			$('#parent_category_name').val('');

			$.ajax({   
				type: "POST",

				cache: false,        
				processData: false,
				contentType: false,
				url: "<?php echo $this->Url->build(["controller" => "Items", "action" => "getAjaxParentSections"]); ?>",
				success: function(data){	
					data = $.parseJSON(data);
						
						$('#parent-category-id').html('');
						$('#parent-category-id').append("<option value=''>--- Select --</option>");
		  					$.each(data, function(index,item){
		  					$('#parent-category-id').append("<option value='"+item.id+"'>"+item.name+"</option>");
						});
						
								
				},
				error: function(data){
									
				}   
			});   
		});

		
		
	$('body').on('click', '#hide-section', function(event){
			event.preventDefault();
			$('#sections-div').slideUp("slow");
	});


});
</script>