<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PageContents Model
 *
 * @property \App\Model\Table\MenusTable&\Cake\ORM\Association\BelongsTo $Menus
 * @property \App\Model\Table\ContentsTable&\Cake\ORM\Association\BelongsTo $Contents
 *
 * @method \App\Model\Entity\PageContent newEmptyEntity()
 * @method \App\Model\Entity\PageContent newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\PageContent[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\PageContent get($primaryKey, $options = [])
 * @method \App\Model\Entity\PageContent findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\PageContent patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\PageContent[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\PageContent|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\PageContent saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\PageContent[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\PageContent[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\PageContent[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\PageContent[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class PageContentsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('page_contents');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Menus', [
            'foreignKey' => 'menu_id',
        ]);
        $this->belongsTo('Contents', [
            'foreignKey' => 'content_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('parent_menu_id')
            ->allowEmptyString('parent_menu_id');

        $validator
            ->integer('menu_id')
            ->allowEmptyString('menu_id');

        $validator
            ->integer('content_id')
            ->allowEmptyString('content_id');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn('menu_id', 'Menus'), ['errorField' => 'menu_id']);
        $rules->add($rules->existsIn('content_id', 'Contents'), ['errorField' => 'content_id']);

        return $rules;
    }

    public function getPageContents($mc): Query{
        $query = $this->find()
        ->contain(['Contents.ContentImages', 'Menus.ParentMenus'])
        ->where([
            'OR' => [
                ['Menus.id'=>$mc->id],
                ['Menus.parent_menu_id'=>$mc->id],
                ['ParentMenus.parent_menu_id'=>$mc->id]
            ]
            ])
            ->order([
                'Menus.name' => 'ASC',
                'Contents.name' => 'ASC'
            ]);

            return $query;
    }
}
