<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contacts Model
 *
 * @method \App\Model\Entity\Contact newEmptyEntity()
 * @method \App\Model\Entity\Contact newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Contact[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contact get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contact findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Contact patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contact[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contact|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contact saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contact[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Contact[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Contact[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Contact[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class ContactsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('contacts');
        $this->setDisplayField('title');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('title')
            ->maxLength('title', 255)
            ->allowEmptyString('title');

        $validator
            ->scalar('content')
            ->maxLength('content', 255)
            ->allowEmptyString('content');

        $validator
            ->scalar('address1')
            ->maxLength('address1', 255)
            ->allowEmptyString('address1');

        $validator
            ->scalar('address2')
            ->maxLength('address2', 255)
            ->allowEmptyString('address2');

        $validator
            ->scalar('address3')
            ->maxLength('address3', 255)
            ->allowEmptyString('address3');

        $validator
            ->scalar('postal_address')
            ->maxLength('postal_address', 50)
            ->allowEmptyString('postal_address');

        $validator
            ->scalar('street')
            ->maxLength('street', 255)
            ->allowEmptyString('street');

        $validator
            ->scalar('phone1')
            ->maxLength('phone1', 50)
            ->allowEmptyString('phone1');

        $validator
            ->scalar('phone2')
            ->maxLength('phone2', 50)
            ->allowEmptyString('phone2');

        $validator
            ->scalar('phone3')
            ->maxLength('phone3', 50)
            ->allowEmptyString('phone3');

        $validator
            ->scalar('email1')
            ->maxLength('email1', 255)
            ->allowEmptyString('email1');

        $validator
            ->scalar('email2')
            ->maxLength('email2', 255)
            ->allowEmptyString('email2');

        $validator
            ->scalar('email3')
            ->maxLength('email3', 255)
            ->allowEmptyString('email3');

        $validator
            ->scalar('email_copy')
            ->maxLength('email_copy', 500)
            ->allowEmptyString('email_copy');

        $validator
            ->scalar('form_email1')
            ->maxLength('form_email1', 255)
            ->allowEmptyString('form_email1');

        $validator
            ->scalar('form_email2')
            ->maxLength('form_email2', 255)
            ->allowEmptyString('form_email2');

        $validator
            ->scalar('form_email3')
            ->maxLength('form_email3', 255)
            ->allowEmptyString('form_email3');

        $validator
            ->scalar('longitude')
            ->maxLength('longitude', 50)
            ->allowEmptyString('longitude');

        $validator
            ->scalar('latitude')
            ->maxLength('latitude', 50)
            ->allowEmptyString('latitude');

        $validator
            ->scalar('google_map_address')
            ->maxLength('google_map_address', 16777215)
            ->allowEmptyString('google_map_address');

        $validator
            ->scalar('facebook')
            ->maxLength('facebook', 255)
            ->allowEmptyString('facebook');

        $validator
            ->scalar('twitter')
            ->maxLength('twitter', 255)
            ->allowEmptyString('twitter');

        $validator
            ->scalar('instagram')
            ->maxLength('instagram', 255)
            ->allowEmptyString('instagram');

        $validator
            ->scalar('linkedin')
            ->maxLength('linkedin', 255)
            ->allowEmptyString('linkedin');

        $validator
            ->scalar('othersocialmedialink')
            ->maxLength('othersocialmedialink', 255)
            ->allowEmptyString('othersocialmedialink');

        $validator
            ->scalar('whatsapp')
            ->maxLength('whatsapp', 255)
            ->allowEmptyString('whatsapp');

        $validator
            ->scalar('youtube')
            ->maxLength('youtube', 500)
            ->allowEmptyString('youtube');

        $validator
            ->scalar('working_days')
            ->maxLength('working_days', 30)
            ->allowEmptyString('working_days');

        $validator
            ->scalar('working_hours')
            ->maxLength('working_hours', 20)
            ->allowEmptyString('working_hours');

        $validator
            ->scalar('week_ends')
            ->maxLength('week_ends', 30)
            ->allowEmptyString('week_ends');

        $validator
            ->scalar('week_ends_hours')
            ->maxLength('week_ends_hours', 20)
            ->allowEmptyString('week_ends_hours');

        $validator
            ->integer('show_on_footer_address1')
            ->notEmptyString('show_on_footer_address1');

        $validator
            ->integer('show_on_footer_address2')
            ->notEmptyString('show_on_footer_address2');

        $validator
            ->integer('show_on_footer_address3')
            ->notEmptyString('show_on_footer_address3');

        $validator
            ->integer('show_on_footer_postal_address')
            ->notEmptyString('show_on_footer_postal_address');

        $validator
            ->integer('show_on_footer_street')
            ->notEmptyString('show_on_footer_street');

        $validator
            ->integer('show_on_footer_phone1')
            ->notEmptyString('show_on_footer_phone1');

        $validator
            ->integer('show_on_footer_phone2')
            ->notEmptyString('show_on_footer_phone2');

        $validator
            ->integer('show_on_footer_phone3')
            ->notEmptyString('show_on_footer_phone3');

        $validator
            ->integer('show_on_footer_email1')
            ->notEmptyString('show_on_footer_email1');

        $validator
            ->integer('show_on_footer_email2')
            ->notEmptyString('show_on_footer_email2');

        $validator
            ->integer('show_on_footer_email3')
            ->notEmptyString('show_on_footer_email3');

        $validator
            ->integer('show_on_footer_copy')
            ->notEmptyString('show_on_footer_copy');

        $validator
            ->integer('show_on_footer_workingDays')
            ->notEmptyString('show_on_footer_workingDays');

        $validator
            ->integer('show_on_footer_workingHours')
            ->notEmptyString('show_on_footer_workingHours');

        $validator
            ->integer('show_on_footer_weekEnds')
            ->notEmptyString('show_on_footer_weekEnds');

        $validator
            ->integer('show_on_footer_weekhours')
            ->notEmptyString('show_on_footer_weekhours');

        $validator
            ->integer('show_on_footer_facebook')
            ->notEmptyString('show_on_footer_facebook');

        $validator
            ->integer('show_on_footer_twitter')
            ->notEmptyString('show_on_footer_twitter');

        $validator
            ->integer('show_on_footer_instagram')
            ->notEmptyString('show_on_footer_instagram');

        $validator
            ->integer('show_on_footer_linkedin')
            ->notEmptyString('show_on_footer_linkedin');

        $validator
            ->integer('show_on_footer_youtube')
            ->notEmptyString('show_on_footer_youtube');

        $validator
            ->integer('show_on_footer_whatsapp')
            ->notEmptyString('show_on_footer_whatsapp');

        $validator
            ->integer('show_on_footer_othersocialmedialink')
            ->notEmptyString('show_on_footer_othersocialmedialink');

        $validator
            ->integer('show_on_header_address1')
            ->notEmptyString('show_on_header_address1');

        $validator
            ->integer('show_on_header_address2')
            ->notEmptyString('show_on_header_address2');

        $validator
            ->integer('show_on_header_address3')
            ->notEmptyString('show_on_header_address3');

        $validator
            ->integer('show_on_header_postal_address')
            ->notEmptyString('show_on_header_postal_address');

        $validator
            ->integer('show_on_header_street')
            ->notEmptyString('show_on_header_street');

        $validator
            ->integer('show_on_header_phone1')
            ->notEmptyString('show_on_header_phone1');

        $validator
            ->integer('show_on_header_phone2')
            ->notEmptyString('show_on_header_phone2');

        $validator
            ->integer('show_on_header_phone3')
            ->notEmptyString('show_on_header_phone3');

        $validator
            ->integer('show_on_header_email1')
            ->notEmptyString('show_on_header_email1');

        $validator
            ->integer('show_on_header_email2')
            ->notEmptyString('show_on_header_email2');

        $validator
            ->integer('show_on_header_email3')
            ->notEmptyString('show_on_header_email3');

        $validator
            ->integer('show_on_header_copy')
            ->notEmptyString('show_on_header_copy');

        $validator
            ->integer('show_on_header_workingDays')
            ->notEmptyString('show_on_header_workingDays');

        $validator
            ->integer('show_on_header_workingHours')
            ->notEmptyString('show_on_header_workingHours');

        $validator
            ->integer('show_on_header_weekEnds')
            ->notEmptyString('show_on_header_weekEnds');

        $validator
            ->integer('show_on_header_weekhours')
            ->notEmptyString('show_on_header_weekhours');

        $validator
            ->integer('show_on_header_facebook')
            ->notEmptyString('show_on_header_facebook');

        $validator
            ->integer('show_on_header_twitter')
            ->notEmptyString('show_on_header_twitter');

        $validator
            ->integer('show_on_header_instagram')
            ->notEmptyString('show_on_header_instagram');

        $validator
            ->integer('show_on_header_linkedin')
            ->notEmptyString('show_on_header_linkedin');

        $validator
            ->integer('show_on_header_youtube')
            ->notEmptyString('show_on_header_youtube');

        $validator
            ->integer('show_on_header_whatsapp')
            ->notEmptyString('show_on_header_whatsapp');

        $validator
            ->integer('show_on_header_othersocialmedialink')
            ->notEmptyString('show_on_header_othersocialmedialink');

        return $validator;
    }
}
