<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Authentication\PasswordHasher\DefaultPasswordHasher;
use Cake\ORM\Entity;

/**
 * User Entity
 *
 * @property int $id
 * @property string|null $title
 * @property string|null $first_name
 * @property string|null $last_name
 * @property string|null $image_path
 * @property string|null $alternative_email
 * @property string|null $gender
 * @property \Cake\I18n\FrozenTime|null $date_of_birth
 * @property string $password
 * @property string|null $token
 * @property \Cake\I18n\FrozenTime|null $token_created_at
 * @property string|null $email
 * @property \Cake\I18n\FrozenTime|null $last_accessed
 * @property \Cake\I18n\FrozenTime|null $date
 * @property int $status_id
 * @property int|null $registration_stage_id
 * @property string|null $phone_1
 * @property string|null $phone_2
 * @property string|null $token_pw
 * @property int|null $approuved
 */
class User extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'title' => true,
        'first_name' => true,
        'last_name' => true,
        'image_path' => true,
        'alternative_email' => true,
        'gender' => true,
        'date_of_birth' => true,
        'password' => true,
        'token' => true,
        'token_created_at' => true,
        'email' => true,
        'last_accessed' => true,
        'date' => true,
        'status_id' => true,
        'registration_stage_id' => true,
        'phone_1' => true,
        'phone_2' => true,
        'token_pw' => true,
        'approuved' => true,
    ];

    /**
     * Fields that are excluded from JSON versions of the entity.
     *
     * @var array<string>
     */
    protected $_hidden = [
        'password',
        'token',
    ];

    // Add this method
    protected function _setPassword(string $password): ?string
    {
        if (strlen($password) > 0) {
            return (new DefaultPasswordHasher())->hash($password);
        }
    }
}
