<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Banner Entity
 *
 * @property int $id
 * @property string|null $title
 * @property string|null $description
 * @property string|null $image_path
 * @property int $status
 * @property string|null $url_link
 * @property int $order_value
 * @property int $section_id
 * @property \Cake\I18n\FrozenTime|null $created
 * @property \Cake\I18n\FrozenTime|null $modified
 *
 * @property \App\Model\Entity\SectionBannerAssoc[] $section_banner_assoc
 */
class Banner extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'title' => true,
        'description' => true,
        'image_path' => true,
        'status' => true,
        'url_link' => true,
        'order_value' => true,
        'section_id' => true,
        'created' => true,
        'modified' => true,
        'section_banner_assoc' => true,
    ];
}
