<?php
namespace App\Controller;

use App\Controller\AppController;
use cake\ORM\TableRegistry;
use Cake\I18n\Time;
use Cake\Event\EventInterface;
use Cake\Core\Configure;
use Cake\Utility\Inflector;


/**
 * Settings Controller
 *
 */
class SettingsController extends AppController
{
    public function initialize(): void
    {
        parent::initialize();

        $this->loadModel('appSettings');
        $this->loadModel('Menus');
    }

    public function isAuthorized($user)
    {
        return true;
    }

    /**
     * Index method
     *
     * @return void
     */
    public function index()
    {
        $pageTitle = "Site Identity Settings";
        $siteName = $this->AppSettings->find("All")->where(["setting_name" => 'SITE-NAME'])->first();
        $siteName = $siteName->setting_value;

        $siteLogo = $this->AppSettings->find("All")->where(["setting_name" => 'SITE-LOGO'])->first();
        $siteLogo = $siteLogo->setting_value;

        $this->set(compact('pageTitle', 'siteName', 'siteLogo'));
    }

    public function updateSiteName()
    {
        if ($this->request->is(['post', 'patch', 'put'])) {
            $data = $this->request->getData();
            $image_field = 'image1';
            $logoId = 2;
            $image_path = $this->request->getData($image_field);
            $imageSize = $image_path->getSize();
            
            if ($imageSize > 0) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $data[$image_field], null, null, false);
                if (!empty($fileOK['urls'])) {
                    $siteLogo = $data['image_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                }
            } else {
                $siteLogo = 'temp' ;
            }

            $siteId = 1;               
            //  debug($image_path->getClientFilename());exit;


            $this->AppSettings->updateAll(['setting_value' => $siteLogo], ['id' => $logoId]);
            $this->AppSettings->updateAll(['setting_value' => $data['site_name']], ['id' => $siteId]);

            $this->Flash->success(__('Site information updated successfully'));
            return $this->redirect($this->referer());
        }
        $this->set(compact('image_field', 'siteName'));
    }

    // show all menus with parent id 0
    public function mainMenuListings()
    {
        $pageTitle = 'All Menus';
        // $listings = $this->Menus->find('all')->where(['parent_menu_id'=>0]);
        $listings = $this->Menus->find('all', [
            'conditions' => [
                'parent_menu_id' => 0
            ]
        ]);

        // $listings = $this->paginate($this->Menus, ['scope' => 'listings']);

        $listings = $this->paginate($listings);

        $this->set(compact('listings', 'pageTitle'));
    }

    public function pendingMenu($id = null)
    {
        $pageTitle = 'Pending Menus';

        $listings = $this->Menus->find('all')->where(["status" => 0]);
        $listings = $this->paginate($listings);


        $this->set(compact('pageTitle', 'listings'));
    }

    public function enableMenu()
    {
        $pageTitle = 'Enabled Menus';

        // $listings = $this->Menus->find('all')->where(["status"=>1]);
        $listings = $this->Menus->find('all', [
            'conditions' => [
                'status' => 1
            ]
        ]);

        $listings = $this->paginate($listings);


        $this->set(compact('pageTitle', 'listings'));
    }

    public function disableMenu()
    {
        $pageTitle = 'Disabled Menus';

        $listings = $this->Menus->find('all')->where(["status" => 99]);
        $listings = $this->paginate($listings);


        $this->set(compact('pageTitle', 'listings'));
    }

    public function editedMenu()
    {
        $pageTitle = 'Edited Menus';

        $listings = $this->Menus->find('all')->where(["status" => 2]);
        $listings = $this->paginate($listings);


        $this->set(compact('pageTitle', 'listings'));

    }

    public function editMenu($id = null)
	{
		$menu = $this->Menus->get($id);
		if ($this->request->is(['post', 'patch', 'put'])) {
			// $this->request->data['slug'] = Inflector::slug($this->request->data['slug']);
			$menu = $this->Menus->patchEntity($menu, $this->request->getData());

			if ($this->Menus->save($menu)) {
				$this->Flash->success(__('Menu  item name change successfully.'));
				$this->redirect(array('controller' => 'Settings', 'action' => 'editedMenu'));

			}else {
						$this->Flash->error(__('The row could not be edited. Try again'));
					}

		}
		// $menuitem = $this->Menus->find('All')->where(["slug" => $this->slug])->first();
		// if ($this->request->is(['post', 'put', 'patch'])) {

		// 	$menuitem = $this->Menus->patchEntity($menuitem, $this->request->data);
		// 	if ($this->Menus->save($menuitem)) {
		// 		$this->Flash->success(__('Menu  item name change successfully.'));
		// 	} else {
		// 		$this->Flash->error(__('The row could not be edited. Try again'));
		// 	}
		// }
		$this->set(compact('menu'));
	}

}