<sections>
    <div class="container bg-light pt-5 rounded-4 mb-3">
        <div class="row justify-content-center">
            <div class="col-12 col-lg-9">
<div class="container py-4">
    <?= $this->Form->create(null, [
        'url' => ['controller' => 'Settings', 'action' => 'updateSiteName'],
        'enctype' => 'multipart/form-data',
        'class' => 'needs-validation',
        'novalidate'
    ]) ?>

    <div class="row mb-4">
        <label for="site-name" class="col-sm-2 col-form-label fw-bold">Site Name</label>
        <div class="col-sm-10">
            <?= $this->Form->control('site_name', [
                'id' => 'site-name',
                'class' => 'form-control',
                'label' => false,
                'required' => true,
                'value' => $siteName,
                'placeholder' => 'Enter site name'
            ]) ?>
        </div>
    </div>

    <div class="row mb-4">
        <label for="logo" class="col-sm-2 col-form-label fw-bold">Upload Logo</label>
        <div class="col-sm-10">
            <?= $this->Form->control('image1', [
                'type' => 'file',
                'id' => 'logo',
                'class' => 'form-control',
                'label' => false
            ]) ?>
        </div>
    </div>

    <?php if (!empty($siteLogo)): ?>
        <div class="row mb-4">
            <label class="col-sm-2 col-form-label fw-bold">Current Logo</label>
            <div class="col-sm-10">
                <?= $this->Html->image(Cake\Core\Configure::read('IMAGE_PREPATH') . $siteLogo, [
                    'class' => 'img-thumbnail',
                    'style' => 'max-width: 300px; height: auto;',
                    'alt' => 'Site Logo'
                ]) ?>
            </div>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-sm-12 text-end">
            <?= $this->Form->button(__('Update'), ['class' => 'btn btn-primary px-4']) ?>
        </div>
    </div>

    <?= $this->Form->end() ?>
</div>

            </div>
        </div>
    </div>
</sections>