<div class="bg-light shadow-sm py-3 mb-3 rounded-3">

  <div class="row justify-content-center ">
    <div class="col-12 col-lg-11">

      <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
        <?= $this->Paginator->limitControl(
          [10 => 10, 25 => 25, 50 => 50, 100 => 100],
          null,
          [
            'label' => 'Items per page:',
            'class' => 'form-select w-auto d-inline-block ms-2'
          ]
        ); ?>

        <?= $this->Form->create(null, ['type' => 'get', 'class' => 'd-flex justify-content-end mt-2 mt-md-0']) ?>
        <?= $this->Form->control('search', [
          'type' => 'text',
          'label' => false,
          'placeholder' => 'Search',
          'id' => 'customSearch',
          'value' => $searchTerm ?? '',
          'class' => 'form-control me-2 w-auto'
        ]) ?>
        <?= $this->Form->button('Search', ['type' => 'submit', 'id' => 'searchBtn', 'class' => 'btn btn-primary']) ?>
        <?= $this->Form->end() ?>
      </div>

      <table class="table table-stripeds table-hover">

        <thead>
          <tr>
            <th>Section</th>
            <th>Name</th>
            <th>Content</th>
            <!-- <th>Status</th> -->
            <th>Home</th>
            <th>Image</th>
            <th>Actions</th>
          </tr>
        </thead>

        <tbody class="table-group-divider">
          <?php foreach ($listings as $listing): ?>
            <?php $img = Cake\Core\Configure::read('IMAGE_PREPATH') . 'noimage.jpg';
            $showImage = false;
            if (!empty($listing->content->content_images) && !empty(trim($listing->content->content_images[0]->image_path))) {
              $img = Cake\Core\Configure::read('IMAGE_PREPATH') . $listing->content->content_images[0]->image_path;
            }

            if (file_exists(realpath($img)) && (filesize(realpath($img)) > 4000)) {
              $showImage = true;
            }
            ?>
            <tr>

              <td data-label="Section"><?= $listing->menu->name ?></td>

              <td data-label="Name" style="width: 15%;"><?= $listing->content->name ?></td>

              <td data-label="Content" style="width: 40%;">
                <?= $this->Text->truncate(strip_tags($listing->content->content), 150, ['ellipsis' => '...', 'exact' => false]) ?>
              </td>

              <!-- <td data-label="Status"><.?= $listing->content->status_name ?></td> -->

              <td data-label="Home"><?= $listing->content->show_on_home == 1 ? 'Yes' : 'No' ?></td>

              <td data-label="Image">
                total:
                <?= is_countable($listing->content->content_images) ? sizeof($listing->content->content_images) : 0 ?>
                <?= is_countable($listing->content->content_images) && sizeof($listing->content->content_images) > 0 ? '<br/>' : '' ?>
                <?= $showImage ? '<a href="' . $this->Url->image($img) . '">' . $this->Html->image($img, ['height' => '80px', 'class' => 'border rounded', 'style' => 'max-width: 100px;']) . '</a>' : '<img src="/placeholder.svg?height=100&width=100" alt="" class="img-thumbnail" style="max-width: 100px;">' ?>
              </td>

              <td>
                <div class="d-flex flex-wrap gap-1">
                  <!-- Edit -->
                  <?= $this->Html->link(
                    '<i class="bi bi-pencil-square"></i>',
                    ['controller' => $this->request->getParam('section') ?? $this->request->getParam('controller'), 'action' => 'edit', $menuitemid, $listing->content->id, $listing->id],
                    ['class' => 'btn btn-sm btn-outline-info', 'escape' => false, 'title' => 'Edit', 'data-bs-toggle' => 'tooltip']
                  ) ?>

                  <!-- Enable / Disable -->
                  <?php if ($listing->content->status == 1): ?>
                    <?= $this->Html->link(
                      '<i class="bi bi-x-circle"></i>',
                      ['controller' => $this->request->getParam('section') ?? $this->request->getParam('controller'), 'action' => 'disableListing', $listing->content->id],
                      ['class' => 'btn btn-sm btn-outline-danger', 'escape' => false, 'title' => 'Disable', 'data-bs-toggle' => 'tooltip']
                    ) ?>
                  <?php else:  ?>
                    
                    <?= $this->Html->link(
                      '<i class="bi bi-check-circle"></i>',
                      ['controller' => $this->request->getParam('section') ?? $this->request->getParam('controller'), 'action' => 'enableListing', $listing->content->id],
                      ['class' => 'btn btn-sm btn-outline-success', 'escape' => false, 'title' => 'Enable', 'data-bs-toggle' => 'tooltip']
                    ) ?>
                  <?php endif?>

                  <!-- Home -->
                  <?php if ($listing->content->show_on_home == 1): ?>
                    <?= $this->Html->link(
                      '<i class="bi bi-house-x"></i>',
                      ['controller' => $this->request->getParam('section') ?? $this->request->getParam('controller'), 'action' => 'removeFromHome', $listing->content->id],
                      ['class' => 'btn btn-sm btn-outline-warning', 'escape' => false, 'title' => 'Remove from Home', 'data-bs-toggle' => 'tooltip']
                    ) ?>
                  <?php else: ?>
                    <?= $this->Html->link(
                      '<i class="bi bi-house-door"></i>',
                      ['controller' => $this->request->getParam('section') ?? $this->request->getParam('controller'), 'action' => 'showOnHome', $listing->content->id],
                      ['class' => 'btn btn-sm btn-outline-primary', 'escape' => false, 'title' => 'Show on Home', 'data-bs-toggle' => 'tooltip']
                    ) ?>
                  <?php endif; ?>

                </div>
              </td>

            </tr>
          <?php endforeach; ?>
        </tbody>

      </table>

      <?php echo $this->element('pagination'); ?>

    </div>
  </div>
</div>