<?php
$currentAction = $this->request->getParam('action');

$menuButtons = [
    ['label' => __('Add'),      'action' => 'addMenu'],
    ['label' => __('All'),      'action' => 'mainMenuListings'],
    ['label' => __('Pending'),  'action' => 'pendingMenu'],
    ['label' => __('Enabled'),  'action' => 'enableMenu'],
    ['label' => __('Disabled'), 'action' => 'disableMenu'],
    ['label' => __('Edited'),   'action' => 'editedMenu'],
    // Uncomment this if needed:
    // ['label' => __('Sub Menu'), 'action' => 'subMenus', 'params' => [$menuitemid]],
];
?>

<section class="border-bottom">
    <div class="container-fluids">
        <div class="row">
            <div class="text-center">
                <ul class="list-inline side-nav">
                    <?php foreach ($menuButtons as $button): 
                        $isActive = $currentAction === $button['action'];
                        $btnClass = $isActive ? 'btn-primary' : 'btn-light';

                        $url = ['controller' => $slug, 'action' => $button['action']];
                        if (!empty($button['params'])) {
                            $url = array_merge($url, $button['params']);
                        }
                    ?>
                        <li class="list-inline-item">
                            <?= $this->Html->link(
                                $button['label'],
                                $url,
                                ['class' => "text-decoration-none btn $btnClass rounded-pill fw-semibold fs-6"]
                            ) ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    </div>
</section>
