<section>
    <div class="container bg-light pt-5 rounded-3 mb-3 my-4">
        <div class="row justify-content-center">
            <div class="col-12 col-lg-8">
                <?= $this->Form->create($menu, ['enctype' => 'multipart/form-data', 'class' => 'form-horizontal row-fluid']) ?>

                <div class="row mb-3">
                    <label for="name" class="col-sm-2 col-xs-12 field-label fw-semibold">Name *</label>
                    <div class="col-sm-10 col-xs-12 text-input mb-3">
                        <?= $this->Form->control('name', [
                            'id' => 'name',
                            'class' => 'form-control',
                            'label' => false,
                            'required' => true
                        ]); ?>
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="description" class="col-sm-2 col-xs-12 field-label fw-semibold">Description *</label>
                    <div class="col-sm-10 col-xs-12 text-input mb-3">
                        <?= $this->Form->control('description', [
                            'id' => 'description',
                            'class' => 'form-control',
                            'label' => false,
                            'required' => true
                        ]); ?>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-xs-12 field-label fw-semibold">Content</label>
                    <div class="col-sm-10 col-xs-12 text-input mb-3">
                        <?= $this->Form->textarea('content', ['class' => 'form-control ckeditor', 'label' => false]); ?>
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="show_on_home" class="col-sm-2 col-xs-12 field-label fw-semibold">Order Value</label>
                    <div class="col-sm-10 col-xs-12 text-input mb-3">
                        <?= $this->Form->control('order_value', [
                            'id' => 'show_on_home',
                            'class' => 'form-control',
                            'label' => false
                        ]); ?>
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="image_path" class="col-sm-2 col-xs-12 field-label fw-semibold">Upload Image</label>
                    <div class="col-sm-10 col-xs-12 text-input mb-3">
                        <?= $this->Form->control('image_path', [
                            'id' => 'image_path',
                            'type' => 'file',
                            'class' => 'form-control',
                            'label' => false
                        ]); ?>
                        <?= $this->Form->hidden('old_image', [
                            'value' => $menu->image_path ?? '',
                            'label' => false
                        ]); ?>
                    </div>
                </div>

                <?php if (!empty($menu->image_path)): ?>
                    <div class="row mb-3">
                        <label class="col-sm-2 col-xs-12 field-label fw-semibold">Current Image</label>
                        <div class="col-sm-10 col-xs-12 text-input mb-3">
                            <div class="border p-2">
                                <?= $this->Html->image(Cake\Core\Configure::read('IMAGE_PREPATH') . $menu->image_path, [
                                    'class' => 'img-fluid rounded',
                                    'style' => 'max-height: 150px;'
                                ]) ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="row">
                    <div class="col-md-12 col-sm-12 d-flex justify-content-end align-items-end my-4">
                        <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary pull-right']) ?>
                    </div>
                </div>

                <?php $this->Form->end() ?>
            </div>
        </div>
    </div>
</section>