<div class="bg-light shadow-sm py-3 mb-3 rounded-3">
  <div class="row g-4">
    <?php foreach ($galleryDetails as $listing): ?>
      <div class="col-12 col-lg-3">

        <?= $this->Html->image(Cake\Core\Configure::read('IMAGE_PREPATH', '') . $listing->image_path, [
          'id' => 'image',
          'class' => 'img-thumbnail',
          'alt' => h($listing->name) // Added alt attribute for accessibility
        ]) ?>

        <div class="text-center">
          <h5 class='fw-medium'>
            <?= $this->Text->truncate(h(strip_tags($listing->name)), 90, ['ellipsis' => '...', 'exact' => false]) ?>
          </h5>
        </div>

         <!-- Content Buttons -->
             <div class="text-center mt-4">
    <div class="d-inline-flex flex-wrap gap-2 justify-content-center">
        <?php if (in_array($listing->status, [0, 2, 99])): ?>
            <?= $this->Html->link(
                '<i class="bi bi-check-circle-fill me-1"></i> Enable',
                ['controller' => 'Gallery', 'action' => 'enable', $listing->id],
                [
                    'class' => 'btn btn-outline-success',
                    'escape' => false,
                    'title' => 'Enable this item',
                    'data-bs-toggle' => 'tooltip'
                ]
            ) ?>
        <?php elseif ($listing->status == 1): ?>
            <?= $this->Html->link(
                '<i class="bi bi-x-circle-fill me-1"></i> Disable',
                ['controller' => 'Gallery', 'action' => 'disable', $listing->id],
                [
                    'class' => 'btn btn-outline-secondary',
                    'escape' => false,
                    'title' => 'Disable this item',
                    'data-bs-toggle' => 'tooltip'
                ]
            ) ?>
        <?php endif; ?>

        <?= $this->Html->link(
            '<i class="bi bi-trash-fill me-1"></i> Remove',
            ['controller' => 'Gallery', 'action' => 'remove', $listing->id],
            [
                'class' => 'btn btn-outline-danger',
                'escape' => false,
                'title' => 'Remove this item permanently',
                'data-bs-toggle' => 'tooltip',
                'onclick' => "return confirm('Are you sure you want to remove this item?')"
            ]
        ) ?>
    </div>
</div>


      </div>
    <?php endforeach ?>

  </div>
</div>