<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Menu Entity
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $description
 * @property int $parent_menu_id
 * @property int $status
 * @property string|null $slug
 * @property int|null $show_on_home
 * @property int $show_on_footer
 * @property string|null $image_path
 * @property string|null $content
 * @property int|null $home_order
 * @property int|null $order_value
 * @property string|null $url
 * @property \Cake\I18n\DateTime|null $date_created
 * @property \Cake\I18n\DateTime $date_modified
 *
 * @property \App\Model\Entity\PageContent[] $page_contents
 * @property \App\Model\Entity\PageProduct[] $page_products
 */
class Menu extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'description' => true,
        'parent_menu_id' => true,
        'status' => true,
        'slug' => true,
        'show_on_home' => true,
        'show_on_footer' => true,
        'image_path' => true,
        'content' => true,
        'home_order' => true,
        'order_value' => true,
        'url' => true,
        'date_created' => true,
        'date_modified' => true,
        'page_contents' => true,
        'page_products' => true,
    ];
}
