<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * File Entity
 *
 * @property int $id
 * @property string|null $title
 * @property string|null $description
 * @property string|null $file_path
 * @property int|null $status
 * @property string|null $file_name
 * @property string|null $file_type
 * @property string|null $file_format
 * @property int|null $file_size
 * @property \Cake\I18n\DateTime|null $date_created
 * @property \Cake\I18n\DateTime|null $date_modified
 */
class File extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'title' => true,
        'description' => true,
        'file_path' => true,
        'status' => true,
        'file_name' => true,
        'file_type' => true,
        'file_format' => true,
        'file_size' => true,
        'date_created' => true,
        'date_modified' => true,
    ];
}
