<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Content Entity
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $content
 * @property string|null $caption
 * @property string|null $image_path
 * @property string|null $file_path
 * @property int $status
 * @property string|null $level
 * @property int|null $show_on_home
 * @property string|null $fa_icon
 * @property int|null $order_value
 * @property string|null $info1
 * @property string|null $map_address
 * @property \Cake\I18n\DateTime $date_created
 * @property \Cake\I18n\DateTime|null $date_modified
 *
 * @property \App\Model\Entity\ContentImage[] $content_images
 * @property \App\Model\Entity\PageContent[] $page_contents
 */
class Content extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'content' => true,
        'caption' => true,
        'image_path' => true,
        'file_path' => true,
        'status' => true,
        'level' => true,
        'show_on_home' => true,
        'fa_icon' => true,
        'order_value' => true,
        'info1' => true,
        'map_address' => true,
        'date_created' => true,
        'date_modified' => true,
        'content_images' => true,
        'page_contents' => true,
    ];
}
