<?php

namespace App\Controller;

use App\Controller\AppController;
use cake\ORM\TableRegistry;
use Cake\I18n\Time;
use Cake\Event\EventInterface;
use Cake\Core\Configure;
use Cake\Log\Log;

/**
 * Items Controller
 *
 * @property \App\Model\Table\ItemsTable $Items and AutoSparePartsTable $AutoSpareParts
 */
class BannersController extends AppController
{
    public function initialize(): void
    {
        parent::initialize();

        $this->banners = $this->fetchTable('Banners');
        $this->menus = $this->fetchTable('Menus');
    }

    public function beforeRender(EventInterface $event)
    {
        parent::beforeRender($event);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->getParam('action');
        return true;
    }

    public function index($slug = null)
    {
        $pageTitle = 'All Home Banners';
        $homePageBanners = $this->banners->findHomePageBanners();
        $listings = $this->paginate($homePageBanners);

        $this->set(compact('pageTitle', 'listings'));
    }

    public function add()
    {
        $cmsbanners = $this->banners->newEmptyEntity();
        $sectionlist = $this->menus->enaledMenus();
        $pageTitle = 'Add Home Banners';
        $pageContentTitle = '';

        if ($this->request->is(['post'])) {
            $data = $this->request->getData();
            $image_field = 'image1';
            $image_path = $this->request->getData($image_field);
            $imageSize = $image_path->getSize();

            // Check if there is an image and then update the image path
            if ($imageSize > 0) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $data['image1']);

                if (!empty($fileOK['urls'])) {
                    $data['image_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                }
            } else {
                $data['image1'] = 'temp';
            }

            $cmsbanners = $this->banners->patchEntity($cmsbanners, $data);

            if ($this->banners->save($cmsbanners)) {
                $this->Flash->success(__('Banners added successfully.'));
                return $this->redirect(['action' => 'pendingListings']);

            } else {
                $this->Flash->error(__('The row could not be save. Try again'));
            }
        }

        $this->set(compact('pageTitle', 'cmsbanners', 'sectionlist', 'pageContentTitle'));
    }
    public function edit($id)
    {
        $pageTitle = 'Edit Home Banners';
        $pageSubTitle = 'Home ';

        $cmsbanners = $this->banners->get($id);
        $sectionlist = $this->menus->find('all')->where(['status' => 1]);

        if ($this->request->is(['post', 'put', 'patch'])) {
            $data = $this->request->getData();
            $image_field = 'image1';
            $image_path = $this->request->getData($image_field);
            $imageSize = $image_path->getSize();

            if (isset($data[$image_field])) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $data[$image_field], null, null, false);
                if (!empty($fileOK['urls'])) {
                    $data['image_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                }
            } else {
                $data['image_path'] = 'temp';
            }

            $data['status'] = 2;
            $cmsbanners = $this->Banners->patchEntity($cmsbanners, $data);

            if ($this->Banners->save($cmsbanners)) {
                $this->Flash->success(__('banners added successfully.'));
                return $this->redirect(['action' => 'editedListings']);
            } else {
                $this->Flash->error(__('The row could not be save. Try again'));
            }
        }
        $this->set(compact('pageTitle', 'cmsbanners', 'sectionlist', 'pageSubTitle'));
    }

    public function sectionTopIndex()
    {
        $pageTitle = 'All Section Banners';
        $homePageBanners = $this->banners->findSectionTopBanners();
        $listings = $this->paginate($homePageBanners);

        $this->set(compact('pageTitle', 'listings'));
    }

    public function sectionTopAdd()
    {
        $cmsbanners = $this->banners->newEmptyEntity();
        $sectionlist = $this->menus->enaledMenus();
        $pageTitle = 'Add Section Banners';
        $pageContentTitle = '';

        if ($this->request->is(['post'])) {
            $data = $this->request->getData();
            $image_field = 'image1';
            $image_path = $this->request->getData($image_field);
            $imageSize = $image_path->getSize();

            // Check if there is an image and then update the image path
            if ($imageSize > 0) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $data['image1']);

                if (!empty($fileOK['urls'])) {
                    $data['image_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                }
            } else {
                $data['image1'] = 'temp';
            }

            $data['status'] = 5;
            $cmsbanners = $this->banners->patchEntity($cmsbanners, $data);

            if ($this->banners->save($cmsbanners)) {
                $this->Flash->success(__('Banners added successfully.'));
                return $this->redirect(['action' => 'sectionTopIndex']);

            } else {
                $this->Flash->error(__('The row could not be save. Try again'));
            }
        }

        $this->set(compact('pageTitle', 'cmsbanners', 'sectionlist', 'pageContentTitle'));
    }

    public function editSectionTopBanner($id)
    {
        $pageTitle = 'Edit Section Banners';
        $pageSubTitle = 'Home ';
        $pageContentTitle = '';
        $cmsbanners = $this->banners->get($id);
        $sectionlist = $this->menus->find('all')->where(['status' => 1]);

        if ($this->request->is(['post', 'put', 'patch'])) {
            $data = $this->request->getData();
            $image_field = 'image1';
            $image_path = $this->request->getData($image_field);
            $imageSize = $image_path->getSize();

            if (isset($data[$image_field])) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $data[$image_field], null, null, false);
                if (!empty($fileOK['urls'])) {
                    $data['image_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                }
            } else {
                $data['image_path'] = 'temp';
            }

            $data['status'] = 5;
            $cmsbanners = $this->Banners->patchEntity($cmsbanners, $data);

            if ($this->Banners->save($cmsbanners)) {
                $this->Flash->success(__('banners added successfully.'));
                return $this->redirect(['action' => 'sectionTopIndex']);
            } else {
                $this->Flash->error(__('The row could not be save. Try again'));
            }
        }
        $this->set(compact('pageTitle', 'pageContentTitle', 'cmsbanners', 'sectionlist', 'pageSubTitle'));
    }

    public function enable($id = null)
    {
        $result = $this->banners->enable($id);

        if ($result) {
            $this->Flash->success(__('Content has been DISABLED successfully.'));
        } else {
            throw new NotFoundException(__('Content not found or already disabled.'));
        }

        return $this->redirect($this->referer());
    }

    public function disable($id = null)
    {
        $result = $this->banners->disable($id);

        if ($result) {
            $this->Flash->success(__('Content has been DISABLED successfully.'));
        } else {
            throw new NotFoundException(__('Content not found or already disabled.'));
        }

        return $this->redirect($this->referer());
    }

    public function pendingListings()
    {
        $pageTitle = 'Pending Home Banners';
        $pendingBanners = $this->banners->pending();
        $listings = $this->paginate($pendingBanners);

        $this->set(compact('pageTitle', 'listings'));
    }

    public function enabledListings()
    {
        $pageTitle = 'Enabled Home Banners';
        $enaledBanners = $this->banners->enabled();
        $listings = $this->paginate($enaledBanners);

        $this->set(compact('pageTitle', 'listings'));
    }

    public function disableListings()
    {
        $pageTitle = 'Disabled Home Banners';
        $disabledBanners = $this->banners->disableListings();
        $listings = $this->paginate($disabledBanners);

        $this->set(compact('pageTitle', 'listings'));
    }

    public function editedListings()
    {
        $pageTitle = 'Edited Home Banners';
        $editedBanners = $this->banners->editedListings();
        $listings = $this->paginate($editedBanners);

        $this->set(compact('pageTitle', 'listings'));
    }

    public function enableSectionTopBanner($id = null)
    {
        $result = $this->banners->enableSectionTopBanner($id);

        if ($result) {
            $this->Flash->success(__('Content has been DISABLED successfully.'));
        } else {
            throw new NotFoundException(__('Content not found or already disabled.'));
        }

        return $this->redirect($this->referer());
    }

    public function disableSectionTopBanner($id = null)
    {
        $result = $this->banners->disableSectionTopBanner($id);

        if ($result) {
            $this->Flash->success(__('Content has been DISABLED successfully.'));
        } else {
            throw new NotFoundException(__('Content not found or already disabled.'));
        }

        return $this->redirect($this->referer());
    }

     public function disabledSectionTopBannerListings()
    {
        $pageTitle = 'Disabled Section Banners';
        $disabledBanners = $this->banners->disabledSectionTopBannerListings();
        $listings = $this->paginate($disabledBanners);

        $this->set(compact('pageTitle', 'listings'));
    }

}