<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */

$cakeDescription = 'CakePHP: the rapid development php framework';
?>
<!DOCTYPE html>
<html>

<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
</head>

<title>
    <?= $cakeDescription ?>:
    <?= $this->fetch('title') ?>
</title>

<?= $this->Html->meta('icon') ?>

<?= $this->fetch('meta') ?>
<?= $this->fetch('css') ?>
<?= $this->fetch('script') ?>
</head>

<body>

    <nav class="">
        <?php echo $this->element('top_bar'); ?>
    </nav>

    <main class="border-bottom border-3 border-secondry pb-5s">
        <div class="container">
            <?= $this->fetch('content') ?>
        </div>

        <div class="container mb-0 ms-5">
            <span class="copyright">&copy; 2017 <a href="https://www.themeineed.com" target="_blank">Theme I
                    Need</a>.
                All Rights Reserved.
            </span>
        </div>
    </main>


    <div class="mt-5">
        <?php echo $this->element('footer'); ?>
    </div>

</body>

</html>