<div class="bg-light shadow-sm py-3 mb-3 rounded-3">

  <div class="row justify-content-center ">
    <div class="col-12 col-lg-11">

      <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
        <?= $this->Paginator->limitControl(
          [10 => 10, 25 => 25, 50 => 50, 100 => 100],
          null,
          [
            'label' => 'Items per page:',
            'class' => 'form-select w-auto d-inline-block ms-2'
          ]
        ); ?>

        <?= $this->Form->create(null, ['type' => 'get', 'class' => 'd-flex justify-content-end mt-2 mt-md-0']) ?>
        <?= $this->Form->control('search', [
          'type' => 'text',
          'label' => false,
          'placeholder' => 'Search',
          'id' => 'customSearch',
          'value' => $searchTerm ?? '',
          'class' => 'form-control me-2 w-auto'
        ]) ?>
        <?= $this->Form->button('Search', ['type' => 'submit', 'id' => 'searchBtn', 'class' => 'btn btn-primary']) ?>
        <?= $this->Form->end() ?>
      </div>

      <table class="table table-stripeds table-hover">

        <thead>
          <tr>
            <th>Banner</th>
            <th>Title</th>
            <th>Description </th>
            <th>Actions</th>
          </tr>
        </thead>

        <tbody class="table-group-divider">
          <?php foreach ($listings as $listing): ?>
            <?php $image_path = Cake\Core\Configure::read('IMAGE_PREPATH') . $listing->image_path; ?>
            <tr>
              <td data-label="Banner">
                <?= isset($image_path) ? '<a href="' . $this->Url->image($image_path) . '">' . $this->Html->image($image_path, ['height' => '80px', 'class' => 'border rounded', 'style' => 'max-width: 100px;']) . '</a>' : '<img src="/placeholder.svg?height=100&width=100" alt="" class="img-thumbnail" style="max-width: 100px;">' ?>
              </td>

              <td data-label="Title" class="w-25"><?= $listing->title ?></td>

              <td data-label="Description" class="w-50">
                <?= $listing->description ?>
              </td>

              <td>
                <div class="d-flex flex-wrap gap-1">
                  <!-- Edit -->
                  <?= $this->Html->link(
                    '<i class="bi bi-pencil-square"></i>',
                    ['action' => 'editSectionTopBanner', $listing->id],
                    ['class' => 'btn btn-sm btn-outline-info', 'escape' => false, 'title' => 'Edit', 'data-bs-toggle' => 'tooltip']
                  ) ?>

                  <!-- Enable / Disable -->
                  <?php if ($listing->status == 5): ?>
                    <?= $this->Html->link(
                      '<i class="bi bi-x-circle"></i>',
                      ['action' => 'disableSectionTopBanner',$listing->id],
                      ['class' => 'btn btn-sm btn-outline-danger', 'escape' => false, 'title' => 'Disable', 'data-bs-toggle' => 'tooltip']
                    ) ?>
                  <?php else: ?>

                    <?= $this->Html->link(
                      '<i class="bi bi-check-circle"></i>',
                      ['action' => 'enableSectionTopBanner', $listing->id],
                      ['class' => 'btn btn-sm btn-outline-success', 'escape' => false, 'title' => 'Enable', 'data-bs-toggle' => 'tooltip']
                    ) ?>
                  <?php endif ?>

                </div>
              </td>

            </tr>
          <?php endforeach ?>
        </tbody>

      </table>


    </div>
  </div>
</div>