<div class="bg-light shadow-sm py-3 mb-3 rounded-3">

    <div class="row justify-content-center ">
        <div class="col-12 col-lg-11">

            <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
                <?= $this->Paginator->limitControl(
                    [10 => 10, 25 => 25, 50 => 50, 100 => 100],
                    null,
                    [
                        'label' => 'Items per page:',
                        'class' => 'form-select w-auto d-inline-block ms-2'
                    ]
                ); ?>

                <?= $this->Form->create(null, ['type' => 'get', 'class' => 'd-flex justify-content-end mt-2 mt-md-0']) ?>
                <?= $this->Form->control('search', [
                    'type' => 'text',
                    'label' => false,
                    'placeholder' => 'Search',
                    'id' => 'customSearch',
                    'value' => $searchTerm ?? '',
                    'class' => 'form-control me-2 w-auto'
                ]) ?>
                <?= $this->Form->button('Search', ['type' => 'submit', 'id' => 'searchBtn', 'class' => 'btn btn-primary']) ?>
                <?= $this->Form->end() ?>
            </div>

            <table class="table table-stripeds table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Image</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody class="table-group-divider">
                    <?php foreach ($listings as $listing): ?>
                        <?php $img = Cake\Core\Configure::read('IMAGE_PREPATH') . $listing->image_path; ?>
                        <tr>
                            <td>
                                <?= $this->Html->link(__($listing->name), ['controller' => 'gallery', 'action' => 'details', $listing->id]) ?>
                            </td>

                            <td><?= $listing->description ?></td>

                            <td>
                                <?php if (isset($listing->image_path) && trim($listing->image_path) != ''): ?>
                                    <a href="<?= $this->Url->image($img) ?>">
                                        <?= $this->Html->image($img, ['class' => 'img-fluid', 'alt' => $listing->name, 'style' => 'max-height: 70px;']) ?>
                                    </a>
                                <?php endif; ?>
                            </td>

                            <td>
                                <div class="d-flex flex-wrap gap-1">
                                    <!-- Edit -->
                                    <?= $this->Html->link(
                                        '<i class="bi bi-pencil-square"></i>',
                                        ['controller' => 'gallery', 'action' => 'albums', 'edit', $listing->id],
                                        ['class' => 'btn btn-sm btn-outline-info', 'escape' => false, 'title' => 'Edit', 'data-bs-toggle' => 'tooltip']
                                    ) ?>

                                    <!-- Enable / Disable -->
                                    <?php if ($listing->status == 1): ?>
                                        <?= $this->Html->link(
                                            '<i class="bi bi-x-circle"></i>',
                                            ['controller' => 'gallery', 'action' => 'albums', 'disable', $listing->id],
                                            ['class' => 'btn btn-sm btn-outline-danger', 'escape' => false, 'title' => 'Disable', 'data-bs-toggle' => 'tooltip']
                                        ) ?>
                                    <?php else: ?>

                                        <?= $this->Html->link(
                                            '<i class="bi bi-check-circle"></i>',
                                            ['controller' => 'gallery', 'action' => 'albums', 'enable', $listing->id],
                                            ['class' => 'btn btn-sm btn-outline-success', 'escape' => false, 'title' => 'Enable', 'data-bs-toggle' => 'tooltip']
                                        ) ?>
                                    <?php endif ?>

                                </div>
                            </td>

                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

        </div>
    </div>
</div>