<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Content $content
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('List Contents'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="contents form content">
            <?= $this->Form->create($content) ?>
            <fieldset>
                <legend><?= __('Add Content') ?></legend>
                <?php
                    echo $this->Form->control('name');
                    echo $this->Form->control('content');
                    echo $this->Form->control('caption');
                    echo $this->Form->control('image_path');
                    echo $this->Form->control('file_path');
                    echo $this->Form->control('status');
                    echo $this->Form->control('level');
                    echo $this->Form->control('show_on_home');
                    echo $this->Form->control('fa_icon');
                    echo $this->Form->control('order_value');
                    echo $this->Form->control('info1');
                    echo $this->Form->control('map_address');
                    echo $this->Form->control('date_created');
                    echo $this->Form->control('date_modified', ['empty' => true]);
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
