<?php
namespace App\Controller;

use App\Controller\AppController;
use cake\ORM\TableRegistry;
use Cake\I18n\Time;
use Cake\Event\EventInterface;
use Cake\Core\Configure;
use Cake\Utility\Inflector;
use Cake\Utility\Text;



/**
 * Settings Controller
 *
 */
class SettingsController extends AppController
{
    public function initialize(): void
    {
        parent::initialize();

        $this->appSettings = $this->fetchTable('appSettings');
        $this->menus = $this->fetchTable('Menus');
    }

    public function isAuthorized($user)
    {
        return true;
    }

    /**
     * Index method
     *
     * @return void
     */
    public function index()
    {
        $pageTitle = "Site Identity Settings";
        $siteName = $this->appSettings->find("All")->where(["setting_name" => 'SITE-NAME'])->first();
        $siteName = $siteName->setting_value;
        $mainActiveAction = $this->request->getParam('action');

        $siteLogo = $this->appSettings->find("All")->where(["setting_name" => 'SITE-LOGO'])->first();
        $siteLogo = $siteLogo->setting_value;

        $this->set(compact('pageTitle', 'siteName', 'siteLogo', 'mainActiveAction'));
    }

    public function updateSiteName()
    {
        if ($this->request->is(['post', 'patch', 'put'])) {
            $data = $this->request->getData();
            $image_field = 'image1';
            $logoId = 2;
            $image_path = $this->request->getData($image_field);
            $imageSize = $image_path->getSize();

            if ($imageSize > 0) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $data[$image_field], null, null, false);
                if (!empty($fileOK['urls'])) {
                    $siteLogo = $data['image_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                }
            } else {
                $siteLogo = 'temp';
            }

            $siteId = 1;

            $this->appSettings->updateAll(['setting_value' => $siteLogo], ['id' => $logoId]);
            $this->appSettings->updateAll(['setting_value' => $data['site_name']], ['id' => $siteId]);

            $this->Flash->success(__('Site information updated successfully'));
            return $this->redirect($this->referer());
        }
        $this->set(compact('image_field', 'siteName'));
    }

    public function mainMenuListings()
    {
        $pageTitle = 'All Menu';
        $searchTerm = $this->request->getQuery('search');
        $listings = $this->menus->parentMenuListing();
        $query = $this->searchFilters($listings);

        $listings = $this->paginate($query);
        $mainActiveAction = $this->request->getParam('action');


        $this->set(compact('pageTitle', 'listings', 'mainActiveAction', 'searchTerm'));
    }

    public function pendingMenu()
    {
        $pageTitle = 'Pending Menu';
        $listings = $this->menus->pendingMenu();
        $listings = $this->paginate($listings);
        $mainActiveAction = 'mainMenuListings';
        $activeAction = $this->request->getParam('action');


        $this->set(compact('pageTitle', 'listings', 'activeAction', 'mainActiveAction'));
    }

    public function enableMenu()
    {
        $pageTitle = 'Enable Menu';
        $listings = $this->menus->enableMenu();
        $listings = $this->paginate($listings);
        $mainActiveAction = 'mainMenuListings';
        $activeAction = $this->request->getParam('action');

        $this->set(compact('pageTitle', 'listings', 'activeAction', 'mainActiveAction'));
    }
    public function disableMenu()
    {
        $pageTitle = 'Disabled Menu';
        $listings = $this->menus->disableMenu();
        $listings = $this->paginate($listings);
        $mainActiveAction = 'mainMenuListings';
        $activeAction = $this->request->getParam('action');

        $this->set(compact('pageTitle', 'listings', 'activeAction', 'mainActiveAction'));
    }

    public function editedMenu()
    {
        $pageTitle = 'Edited Menu';
        $listings = $this->menus->editedMenu();
        $listings = $this->paginate($listings);
        $mainActiveAction = 'mainMenuListings';
        $activeAction = $this->request->getParam('action');

        $this->set(compact('pageTitle', 'listings', 'activeAction', 'mainActiveAction'));
    }
    // public function editMenus($id = null)
    // {
    //     $pageTitle = 'Edit Menu';

    //     $menu = $this->Menus->get($id);
    //     $menu = $this->menus->patchEntity($menu, $this->request->getData());

    //     if ($this->Menus->save($menu)) {
    //         $this->Flash->success(__('Menu  item name change successfully.'));
    //         $this->redirect(array('controller' => 'Settings', 'action' => 'editedMenu'));

    //     } else {
    //         $this->Flash->error(__('The row could not be edited. Try again'));
    //     }

    //     $this->set(compact('pageTitle'));

    // }

    public function addMenu()
    {
        $pageTitle = 'Add Menu';
        $mainActiveAction = 'mainMenuListings';
        $activeAction = $this->request->getParam('action');

        $menu = $this->menus->newEmptyEntity();

        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $image_path = $this->request->getData('image_path');
            $imageSize = $image_path->getSize();

            $data['slug'] = Text::slug(strtolower($data['name']));

            if ($imageSize > 0) {
                $fileOK = $this->uploadFiles(Configure::read('IMAGE_PREPATH'), $data['image_path']);

                if (!empty($fileOK['urls'])) {
                    $data['image_path'] = substr(
                        $fileOK['file_path'][0],
                        Configure::read('IMAGE_PRELENGTH'),
                        strlen($fileOK['file_path'][0])
                    );
                }
            } else {
                $data['image_path'] = 'temp';
            }

            $menu = $this->menus->patchEntity($menu, $data);

            if ($this->menus->save($menu)) {
                return $this->redirect(['action' => 'mainMenuListings']);
            } else {
                $this->Flash->error(__('The Menu could not be saved. Please, try again.'));
            }
        }

        $this->set(compact('pageTitle', 'menu', 'mainActiveAction', 'activeAction'));
    }

    public function searchFilters($query)
    {
        $searchTerm = $this->request->getQuery('search');

        if ($searchTerm) {
            $query = $this->menus->applySearchFilter($query, $searchTerm);
        }

        return $query;
    }

}