<?php
declare(strict_types=1);

namespace App\Controller;

use Cake\Event\EventInterface;
use App\Controller\AppController;
use cake\ORM\TableRegistry;
use Cake\I18n\Time;
use Cake\Log\Log;

/**
 * Contactus Controller
 *
 * @method \App\Model\Entity\Contactus[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ContactUsController extends AppController
{

    public function initialize(): void
    {
        parent::initialize();
        $this->slug = "contact-us";
        $this->contacts = $this->fetchTable('Contacts');
    }

    public function beforeRender(EventInterface $event)
    {
        parent::beforeRender($event);
    }

    public function isAuthorized($user)
    {
        return true;
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $this->edit(1);
        $this->render('edit');
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */

    public function add()
    {
        // Page title and new Contacts entity
        $pageTitle = 'Add Contacts';
        $cmscontacts = $this->contacts->newEmptyEntity();

        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $cmscontacts = $this->contacts->patchEntity($cmscontacts, $this->request->getData());
            if ($this->contacts->save($cmscontacts)) {
                $this->Flash->success(__('Contact added successfully.'));
                Log::info('Contact added successfully', ['contact_id' => $cmscontacts->id]);
                return $this->redirect(['action' => 'pendingListings']);
            } else {
                $this->Flash->error(__('The contact could not be saved. Please, try again.'));
                Log::warning('Contact save failed', ['errors' => $cmscontacts->getErrors()]);
            }
        }
        $this->set(compact('pageTitle', 'cmscontacts', 'cmscatlist', 'sectionlist'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Contactus id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = 1)
    {
        $pageTitle = 'General Contacts';
        $ob = $this->contacts->find('all')->where(['id' => $id])->first();

        if (!empty($ob)) {
            // Load the existing contact
            $cmscontacts = $this->contacts->get($id);
        } else {
            // Create a new entity if not found
            $cmscontacts = $this->contacts->newEmptyEntity();
        }

        if ($this->request->is(['post', 'put', 'patch'])) {
            $data = $this->request->getData();
            $cmscontacts = $this->contacts->patchEntity($cmscontacts, $data);

            if ($this->contacts->save($cmscontacts)) {
                $this->Flash->success(__('Contacts updated successfully.'));
                Log::info('Contact updated successfully', ['contact_id' => $id]);
                return $this->redirect(['action' => 'edit', $id]);
            } else {
                $this->Flash->error(__('The contact could not be saved. Please, try again.'));
                Log::warning('Contact save failed', ['errors' => $cmscontacts->getErrors()]);
            }
        }

        $this->set(compact('pageTitle', 'cmscontacts'));
    }

}